class IOClass : public ParserIO
{
public:
	IOClass()
	:socket(0)
	{}
	void read_text(char *,int *);
	void write_text(char *,int);
	void set_socket(int s) {
		socket = s;
	}
	void set_parser(Parser *p) {
		parser = p;
	}

private:
	Parser *parser;
	int socket;	// socket
};

void IOClass::read_text(char *s,int *l)
{
	fd_set rfds;
	int n;

	FD_ZERO(&rfds);
	FD_SET(socket, &rfds);
	n = select(socket + 1, &rfds, NULL, NULL, NULL);
	if (n == -1)
	{
		perror("select() failed");
		parser -> m_next_line = NULL;
		return;
	}
	else
	if (!n)		// huh
	{
		printf("select() returns 0 (?)\n");
		parser -> m_next_line = NULL;
		return;
	}
	if (FD_ISSET(socket, &rfds))
	{
		*l = read(socket, s, *l);
		if (*l == -1)
		{
			perror("read() failed");
			parser -> m_next_line = NULL;
		}
		else
		if (*l == 0)
		{
			parser -> m_next_line = NULL;
		}
		else
		{
			printf("read() returns %d\n",*l);
			while (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10)
				s[strlen(s) - 1] = 0;
		}
	}
	else
	{
		printf("socket did not release select() call\n");
		parser -> m_next_line = NULL;
	}
}

void IOClass::write_text(char *s,int l)
{
	if (write(socket, s, l) == -1)
	{
		perror("write() failed");
	}
}

